package gov.va.vamf.scheduling.direct.serializer

import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.databind.DeserializationContext
import com.fasterxml.jackson.databind.ObjectMapper
import gov.va.vamf.scheduling.direct.exception.XSSException
import spock.lang.Specification

import java.nio.charset.StandardCharsets

class XssProtectionDeserializerSpec extends Specification {
    private def mapper = new ObjectMapper()
    private def deserializer = new XSSProtectionDeserializer()

    def deserialize(input) {
        def json = "{\"input\": \"$input\"}"
        InputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8))
        JsonParser parser = mapper.getFactory().createParser(stream)
        DeserializationContext context = mapper.getDeserializationContext()
        parser.nextToken()
        parser.nextToken()
        parser.nextToken()

        deserializer.deserialize(parser, context)
    }

    def 'XSSProtectionDeserializer throws an exception when it encounters a <script> tag'()  {
        given:
        def input = "<script>alert('1')</script>"

        when:
        deserialize(input)

        then:
        thrown XSSException
    }

    def 'XSSProtectionDeserializer leaves safe values alone'() {
        expect:
        deserialize('Boston') == 'Boston'
    }

    def 'XSSProtectionDeserializer leaves an empty string alone'() {
        expect:
        deserialize('') == ''
    }
}
